% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency_scales.R
\name{HzToNotes}
\alias{HzToNotes}
\alias{notesToHz}
\title{Convert between Hz and notes}
\usage{
HzToNotes(x, showCents = FALSE, A4 = 440)

notesToHz(x, A4 = 440)
}
\arguments{
\item{x}{vector or matrix of frequencies or notes}

\item{showCents}{if TRUE, show cents to the nearest notes (cent = 1/100 of a
semitone)}

\item{A4}{frequency of note A in the fourth octave (modern standard ISO 16 or
concert pitch = 440 Hz)}
}
\description{
Converts from Hz to musical notation like A4 - note A of the fourth octave
above C0 (16.35 Hz).
}
\section{Functions}{
\itemize{
\item \code{notesToHz()}: Convert notes to Hz

}}
\examples{
HzToNotes(c(440, 293, 115, 16.35, 4))
notesToHz(c("A4", "D4", "A#2", "C0", "C-2"))

HzToNotes(c(440, 415, 80, 81), showCents = TRUE)
# 80 Hz is almost exactly midway (+49 cents) between D#2 and E2

# Baroque tuning A415, half a semitone flat relative to concert pitch A440
HzToNotes(c(440, 415, 16.35), A4 = 415)
notesToHz(c("A4", "D4", "A#2", "C0", "C-2"), A4 = 415)
}
\seealso{
\code{\link{HzToOther}}
}
