% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchSRI.R
\name{fetchSRI}
\alias{fetchSRI}
\title{Fetch Soil Inventory Resource (SRI) for USFS Region 6}
\usage{
fetchSRI(gdb, ...)
}
\arguments{
\item{gdb}{A \code{character} vector of the GDB(s), e.g. \code{'Deschutes'}.}

\item{...}{Arguments to pass to \link{get_SRI}.}
}
\value{
A list.
}
\description{
This is a higher level wrapper around the \link{get_SRI} and \link{get_SRI_layers}
functions. This function can fetch multiple File Geodatabases (GDB) and returns all the layers within the GDB.
}
\examples{
\dontrun{

# fetch Willamette and Winema SRI

sri <- fetchSRI(gdb = c('will', 'win'), quiet = TRUE)

}
}
\seealso{
\code{get_SRI()} \code{get_SRI_layers()}
}
\author{
Josh Erickson
}
