% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.LeveneT2.R
\name{print.LeveneT2}
\alias{print.LeveneT2}
\title{Prints Levene's test based on Hotelling's \eqn{T^2} test}
\usage{
\method{print}{LeveneT2}(x, long = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{"LeveneT2"}.}

\item{long}{a logical variable indicating whether a long output is desired
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Displays the results of the comparison of multivariate variation in two
samples in which data values are transformed into absolute deviations from
their respective sample medians, and mean vectors of absolute deviations are
compared using Hotelling's \eqn{T^2} test. The argument \code{x}, invisibly, as
for all print methods, is a list of class "\code{LeveneT2}". This \code{print}
method provides two sorts of output depending on whether the \code{long} argument
is \code{TRUE} or \code{FALSE} (the default). The "short" output displays:
\itemize{
\item A description of the analysis.
\item The data frame analyzed.
\item The names of responses in the data frame.
\item The labels of the two-level group factor (samples), with an order
determined by the argument \code{level1} in \code{LeveneT2}.
\item The value of Hotelling's \eqn{T²}-statistic.
\item The value of the \emph{F}-statistic with its corresponding degrees of
freedom for numerator and denominator. When the within-sample
covariance matrices of absolute deviations around medians are not
assumed equal (\code{var.equal = FALSE}), these degrees of freedom are
approximated using the Nel and van der Merwe's (1986) solution to the
multivariate Behrens-Fisher problem, as implemented in \pkg{Hotelling}
package (Curran and Hersh, 2021).
\item The P-value.
}

In addition to the above information, the "long" output lists:
\itemize{
\item Sub-data frames containing the original responses and medians,
separately for each sample.
\item The absolute deviations from sample medians for samples 1 and 2.
\item Vectors of mean absolute deviations around medians for samples 1
and 2, used in Hotelling's \eqn{T²} test.
}
}
\description{
Prints the results produced by \code{\link[smsets]{LeveneT2}}, consisting of
a Levene's test for two multivariate samples based on Hotelling's \eqn{T^2}
test.
}
\examples{
data(sparrows)
LeveneT2.sparrows <- LeveneT2(sparrows, group = Survivorship, level1 = "S",
                              var.equal = TRUE)
# Long output
print(LeveneT2.sparrows, long = TRUE)

}
\references{
Curran, J. and Hersh, T. (2021). \emph{Hotelling: Hotelling's T^2
Test and Variants}. R package version 1.0-8,
\url{https://CRAN.R-project.org/package=Hotelling}.

Nel, D.G. and van de Merwe, C.A. (1986). A solution to the multivariate
Behrens-Fisher problem. \emph{Comm. Statist. Theor. Meth.}, A15, 12,
3719-3736.
}
