% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hotelling.mat.R
\name{Hotelling.mat}
\alias{Hotelling.mat}
\title{Hotelling's \eqn{T^2} test with extra information}
\usage{
Hotelling.mat(x, group, level1)
}
\arguments{
\item{x}{a data frame with one two-level factor and \emph{p} response
variables.}

\item{group}{two-level factor defining groups. It must be one of the columns
in \code{x}.}

\item{level1}{a character string identifying Sample 1. The string must be one
of the factor levels in \code{group}.}
}
\value{
Returns an object of class \code{"Hotelling.mat"}, a list containing
the following components:
\tabular{lllll}{
\code{ name} \tab A character string describing the function. \tab   \cr
\code{T2.list} \tab A list containing two data frames with the mean vector
for the two samples, two covariance matrices, one matrix per sample,
the pooled covariance matrix, the inverse of the pooled covariance matrix,
the Hotelling's \eqn{T^2} statistic, the \eqn{F}-statistic, the degrees of
freedom for the \eqn{F}-statistic and the P-value.
\tab  \cr
\code{group} \tab a character string specifying the name of the two-level
factor defining groups. \tab   \cr
\code{levels.group} \tab a vector of length two, showing the two levels in
factor \code{group}. \tab   \cr
\code{data.name} \tab a character string giving the name of the data. \tab
\cr
\code{data} \tab the data frame analyzed. \tab  \cr
}
}
\description{
An R function which implements Hotelling's \eqn{T^2} test assuming equal
covariance matrices, with extra information.
}
\details{
This function is a simplified version of the function
\code{\link[Hotelling]{hotelling.test}} implemented in the \code{Hotelling}
package for the comparison of mean values of two multivariate samples, under
the assumption that covariance matrices are equal. The \code{summary} methods
in \code{Hotelling.mat} gives more detailed information of the calculations
behind the \eqn{T^2} test.
}
\examples{
data(sparrows)
results.T2 <- Hotelling.mat(sparrows, group = Survivorship, level1 = "S")
# Brief output
results.T2

}
\references{
Manly, B.F.J., Navarro Alberto, J.A. and Gerow, K. (2024)
\emph{Multivariate Statistical Methods. A Primer}. 5th Edn.
Chapman and Hall/CRC.
}
\author{
Jorge Navarro Alberto, \email{ganava4@gmail.com}
}
