% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoxM.F.R
\name{BoxM.F}
\alias{BoxM.F}
\title{F approximation of Box's M test}
\usage{
BoxM.F(x, group)
}
\arguments{
\item{x}{A data frame with \eqn{p + 1} columns (one factor and \emph{p}
response variables).}

\item{group}{The classification factor defining \emph{m} samples or groups.
It must be one of the columns in \code{x}.}
}
\value{
Returns an object of class \code{"BoxM.F"}, a list containing the
following components:
\tabular{lllllllllllll}{
\code{ name} \tab A character string describing the function. \cr
\code{Cov.Mat} \tab A list containing the \emph{m} sample covariance
matrices \cr
\code{Cov.pooled} \tab The pooled covariance matrix \cr
\code{BoxM.stat} \tab The approximate F-statistic \cr
\code{F.BoxM} \tab The calculated F-statistic \cr
\code{df.v1} \tab Numerator degrees of freedom for the F statistic \cr
\code{df.v2} \tab Denominator degrees of freedom for the F statistic \cr
\code{Pvalue} \tab P-value for the F statistic  \cr
\code{group} \tab a character string specifying the name of the
classification factor defining groups.  \cr
\code{levels.group} \tab a vector of length \emph{m}, showing the levels
in factor \code{group}.  \cr
\code{data.name} \tab a character string giving the name of the data.  \cr
\code{variables} \tab a character string vector containing the variable
names.  \cr
\code{data} \tab the data frame analyzed.  \cr
}
}
\description{
An R function which implements an F approximation for testing the homogeneity
of covariance matrices by Box's M. This is an alternative approach to the chi
square approximation which requires group sample-sizes to be at least 20.
}
\details{
For \eqn{m} samples, the \eqn{M} statistic is given by the equation

\deqn{M = \frac{\prod_{j=1}^{m} |\mathbf{C}_j|^{(n_{j}-1)/2}}{|\mathbf{C}|^{(n-m)/2}}}

where

\eqn{n_{j}} is the sample size of the \eqn{j}-th sample,

\eqn{|\mathbf{C}_j|} is the determinant of the covariance matrix for the
\eqn{j}th sample,

\eqn{|\mathbf{C}|} is the determinant of the pooled covariance matrix,

\eqn{n} is the total number of observations.

Large values of \eqn{M} provide evidence that the samples are not from
populations with the same covariance matrix. In addition to the observed
\emph{M}-value itself, the F-approximation involves the sample sizes and the
number of variables analyzed. See the reference for details. Box's test is
sensitive to deviations from normality in the distribution of the variables.
}
\examples{
data(skulls)
resBoxM.F <- BoxM.F(skulls, Period)
# Brief output
resBoxM.F

}
\references{
Manly, B.F.J., Navarro Alberto, J.A. and Gerow, K. (2024)
\emph{Multivariate Statistical Methods. A Primer}. 5th Edn.
Chapman and Hall/CRC.
}
\author{
Jorge Navarro Alberto, \email{ganava4@gmail.com}
}
