% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic2ph.R
\name{logistic2ph}
\alias{logistic2ph}
\title{Sieve maximum likelihood estimator (SMLE) for two-phase logistic regression problems}
\usage{
logistic2ph(
  y_unval = NULL,
  y = NULL,
  x_unval = NULL,
  x = NULL,
  z = NULL,
  data = NULL,
  hn_scale = 1,
  se = TRUE,
  tol = 1e-04,
  max_iter = 1000,
  verbose = FALSE
)
}
\arguments{
\item{y_unval}{Column name of the error-prone or unvalidated binary outcome. This argument is optional. If \code{y_unval = NULL} (the default), \code{y} is treated as error-free.}

\item{y}{Column name that stores the validated value of \code{y_unval} in the second phase. Subjects with missing values of \code{y} are considered as those not selected in the second phase. This argument is required.}

\item{x_unval}{Specifies the columns of the error-prone covariates. This argument is required.}

\item{x}{Specifies the columns that store the validated values of \code{x_unval} in the second phase. Subjects with missing values of \code{x} are considered as those not selected in the second phase. This argument is required.}

\item{z}{Specifies the columns of the accurately measured covariates. This argument is optional.}

\item{data}{Specifies the name of the dataset. This argument is required.}

\item{hn_scale}{Specifies the scale of the perturbation constant in the variance estimation. For example, if \code{hn_scale = 0.5}, then the perturbation constant is \eqn{0.5n^{-1/2}}, where \eqn{n} is the first-phase sample size. The default value is \code{1}. This argument is optional.}

\item{se}{If \code{FALSE}, then the variances of the parameter estimators will not be estimated. The default value is \code{TRUE}. This argument is optional.}

\item{tol}{Specifies the convergence criterion in the EM algorithm. The default value is \code{1E-4}. This argument is optional.}

\item{max_iter}{Maximum number of iterations in the EM algorithm. The default number is \code{1000}. This argument is optional.}

\item{verbose}{If \code{TRUE}, then show details of the analysis. The default value is \code{FALSE}.}
}
\value{
\code{logistic2ph()} returns an object of class \code{"logistic2ph"}. The function \code{coef()} is used to obtain the coefficients of the fitted model. The function \code{summary()} is used to obtain and print a summary of results.

An object of class \code{"logistic2ph"} is a list containing at least the following components:
\item{call}{the matched call.}
\item{coefficients}{A named vector of the logistic regression coefficient estimates.}
\item{covariance}{The covariance matrix of the logistic regression coefficient estimates.}
\item{converge}{In parameter estimation, if the EM algorithm converges, then \code{converge = TRUE}. Otherwise, \code{converge = FALSE}.}
\item{converge_cov}{In variance estimation, if the EM algorithm converges, then \code{converge_cov = TRUE}. Otherwise, \code{converge_cov = FALSE}.}
}
\description{
This function returns the sieve maximum likelihood estimators (SMLE) for the logistic regression model from Lotspeich et al. (2021). See pacakge vigenette for code examples.
}
\details{
Models for \code{logistic2ph()} are specified through the arguments. The dataset input should at least contain columns for unvalidated error-prone outcome, validated error-prone outcome,
unvalidated error-prone covariate(s), validated error-prone covariate(s), and B-spline basis. B-spline basis can be generated from \code{splines::bs()} function, with argument \code{x}
being the unvalidated error-prone covariate(s). See vignette for options in tuning the B-spline basis.
}
\examples{
\dontrun{
# Regression model: ADE ~ CD4 + Prior_ART. ADE and CD4 are partially validated.
data("mock.vccc")
sn <- 20
data.logistic <- spline2ph(x = "CD4_unval", size = 20, degree = 3,
                           data = mock.vccc, group = "Prior_ART",
                           split_group = TRUE)
res_logistic <- logistic2ph(y = "ADE_val", y_unval = "ADE_unval",
                           x = "CD4_val", x_unval = "CD4_unval",
                            z = "Prior_ART", data = data.logistic,
                            hn_scale = 1/2, se = TRUE, tol = 1e-04,
                            max_iter = 1000, verbose = FALSE)
}

}
\references{
Lotspeich, S. C., Shepherd, B. E., Amorim, G. G. C., Shaw, P. A., & Tao, R. (2021). Efficient odds ratio estimation under two-phase sampling using error-prone data from a multi-national HIV research cohort. \emph{Biometrics, biom.13512.} https://doi.org/10.1111/biom.13512
}
