% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move_column.R
\name{move_columns}
\alias{move_columns}
\title{Move columns to other positions in a data frame}
\usage{
move_columns(data, ..., .before, .after)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Unquoted names or character vector with names of variables that
should be move to another position. You may also use functions like
\code{:} or tidyselect's select-helpers.}

\item{.before}{Optional, column name or numeric index of the position where
\code{col} should be moved to. If not missing, \code{col} is moved to the
position \emph{before} the column indicated by \code{.before}.}

\item{.after}{Optional, column name or numeric index of the position where
\code{col} should be moved to. If not missing, \code{col} is moved to the
position \emph{after} the column indicated by \code{.after}.}
}
\value{
\code{data}, with resorted columns.
}
\description{
\code{move_columns()} moves one or more columns in a data frame
   to another position.
}
\note{
If neither \code{.before} nor \code{.after} are specified, the
   column is moved to the end of the data frame by default. \code{.before}
   and \code{.after} are evaluated in a non-standard fashion, so you need
   quasi-quotation when the value for \code{.before} or \code{.after} is
   a vector with the target-column value. See 'Examples'.
}
\examples{
\dontrun{
data(iris)

iris \%>\%
  move_columns(Sepal.Width, .after = "Species") \%>\%
  head()

iris \%>\%
  move_columns(Sepal.Width, .before = Sepal.Length) \%>\%
  head()

iris \%>\%
  move_columns(Species, .before = 1) \%>\%
  head()

iris \%>\%
  move_columns("Species", "Petal.Length", .after = 1) \%>\%
  head()

library(dplyr)
iris \%>\%
  move_columns(contains("Width"), .after = "Species") \%>\%
  head()}

# using quasi-quotation
target <- "Petal.Width"
# does not work, column is moved to the end
iris \%>\%
  move_columns(Sepal.Width, .after = target) \%>\%
  head()

# using !! works
iris \%>\%
  move_columns(Sepal.Width, .after = !!target) \%>\%
  head()
}
