% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPeakTrough.R
\name{getPeakTrough}
\alias{getPeakTrough}
\alias{getPeak}
\alias{getTrough}
\alias{getTakeoff}
\title{Identify peak or trough on curve}
\usage{
getPeakTrough(x, y = NULL, peak = TRUE, takeoff = FALSE, Dy = FALSE)

getPeak(x, y = NULL, peak = TRUE, takeoff = FALSE, Dy = FALSE)

getTrough(x, y = NULL, peak = FALSE, takeoff = FALSE, Dy = FALSE)

getTakeoff(x, y = NULL, peak = FALSE, takeoff = TRUE, Dy = FALSE)
}
\arguments{
\item{x}{vector.}

\item{y}{vector.}

\item{peak}{logical determining whether peak or trough is returned.}

\item{takeoff}{logical determining whether, if \code{peak} is FALSE, the
trough is takeoff.}

\item{Dy}{logical if TRUE then \code{y} is differentiated first (default FALSE).}
}
\value{
A length-2 vector containing the values of \code{x} and \code{y} at
the peak or trough. If none are identified NA's are returned.
}
\description{
Given vectors \code{x} and \code{y}, returns their values at the peak or
trough of the smooth (e.g. cubic spline) curve \code{y ~ x}.
}
\details{
Optionally the trough can be specified as takeoff, which is defined
for a growth velocity curve as the lowest velocity before the pubertal peak,
and if there is no peak then there is by definition no takeoff.
}
\examples{
## create mean height velocity curve
data(heights)
m1 <- sitar(age, height, id, heights, 4)
## plot velocity curve
plot(m1, 'v')
## mark peak, trough and takeoff
xy <- plot_v(m1)
points(t(getPeak(xy)), pch=17)
points(t(getTrough(xy)), pch=25, col=2, bg=2)
points(t(getTakeoff(xy)), pch=25, col=3, bg=3)
}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
