% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{select_arima}
\alias{select_arima}
\alias{select_arma}
\alias{select_ar}
\alias{select_ma}
\title{Run Model Selection Criteria on ARIMA Models}
\usage{
select_arima(
  xt,
  p.min = 0L,
  p.max = 3L,
  d = 0L,
  q.min = 0L,
  q.max = 3L,
  include.mean = TRUE,
  plot = TRUE
)

select_arma(
  xt,
  p.min = 0L,
  p.max = 3L,
  q.min = 0L,
  q.max = 3L,
  include.mean = TRUE,
  plot = TRUE
)

select_ar(xt, p.min = 0L, p.max = 3L, include.mean = TRUE, plot = TRUE)

select_ma(xt, q.min = 0L, q.max = 3L, include.mean = TRUE, plot = TRUE)
}
\arguments{
\item{xt}{A \code{vector} of univariate time series.}

\item{p.min}{An \code{integer} indicating the lowest order of AR(p) process to search.}

\item{p.max}{An \code{integer} indicating the highest order of AR(p) process to search.}

\item{d}{An \code{integer} indicating the differencing order for the data.}

\item{q.min}{An \code{integer} indicating the lowest order of MA(q) process to search.}

\item{q.max}{An \code{integer} indicating the highest order of MA(q) process to search.}

\item{include.mean}{A \code{bool} indicating whether to fit ARIMA with the mean or not.}

\item{plot}{A \code{logical}. If \code{TRUE} (the default) a plot should be produced.}
}
\description{
This function performs model fitting and calculates the model selection criteria to be plotted or used in \code{best_model} function.
}
\examples{
xt = gen_arima(N=100, ar=0.3, d=1, ma=0.3)
x = select_arima(xt, d=1L)

xt = gen_ma1(100, 0.3, 1)
x = select_ma(xt, q.min=2L, q.max=5L)
best_model(x)

xt = gen_arma(10, c(.4,.5), c(.1), 1, 0)  
x = select_arma(xt, p.min = 1L, p.max = 4L,
                q.min = 1L, q.max = 3L)
}
