% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{mergeData}
\alias{mergeData}
\title{Merge two data.tables without modifying inputs}
\usage{
mergeData(dt1, dt2, idvars, na.rm = TRUE)
}
\arguments{
\item{dt1}{First data.table}

\item{dt2}{Second data.table}

\item{idvars}{Character vector of column names to merge by}

\item{na.rm}{Logical. If TRUE, performs an inner join (removing unmatched rows). 
If FALSE, performs a full outer join.}
}
\value{
A new merged data.table with the original key of dt1 preserved
}
\description{
Merge two data.tables without modifying inputs
}
\examples{
def1 <- defData(varname = "x", formula = 0, variance = 1)
def1 <- defData(varname = "xcat", formula = ".3;.2", dist = "categorical")

def2 <- defData(varname = "yBin", formula = 0.5, dist = "binary", id = "xcat")
def2 <- defData(def2, varname = "yNorm", formula = 5, variance = 2)

dt1 <- genData(20, def1)
dt2 <- genData(3, def2)

dtMerge <- mergeData(dt1, dt2, "xcat")
dtMerge
}
\concept{utility}
