% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{vnorm}
\alias{vnorm}
\title{Variate Generation for Normal Distribution}
\usage{
vnorm(n, mean = 0, sd = 1, stream = NULL, antithetic = FALSE, asList = FALSE)
}
\arguments{
\item{n}{number of observations}

\item{mean}{Mean of distribution (default 0)}

\item{sd}{Standard deviation of distribution (default 1)}

\item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
to generate uniform variates to invert via
\code{\link[=qnorm]{stats::qnorm}};
otherwise, an integer in 1:25 indicates the \code{\link[rstream]{rstream}} stream
from which to generate uniform variates to invert via
\code{\link[=qnorm]{stats::qnorm}};}

\item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
variate(s) generated via either \code{\link[=runif]{stats::runif}} or
\code{\link[rstream]{rstream.sample}}; otherwise, uses
\eqn{1 - u}}

\item{asList}{if \code{FALSE} (default), output only the generated
random variates; otherwise, return a list with components suitable for
visualizing inversion. See return for details}
}
\value{
If \code{asList} is FALSE (default), return a vector of random variates.

Otherwise, return a list with components suitable for visualizing inversion,
specifically:
\item{u}{        A vector of generated U(0,1) variates }
\item{x}{        A vector of normal random variates }
\item{quantile}{ Parameterized quantile function }
\item{text}{     Parameterized title of distribution }
}
\description{
Variate Generation for Normal Distribution
}
\details{
Generates random variates from the normal distribution.

Normal variates are generated by inverting uniform(0,1) variates
produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
\code{NULL}) or by \code{\link[rstream]{rstream.sample}}
(if \code{stream} is not \code{NULL}).
In either case, \code{\link[=qnorm]{stats::qnorm}} is used to
invert the uniform(0,1) variate(s).
In this way, using \code{vnorm} provides a monotone and synchronized
binomial variate generator, although not particularly fast.

The stream indicated must be an integer between 1 and 25 inclusive.

The normal distribution has density

\if{html}{\out{<div class="sourceCode">}}\preformatted{ \deqn{f(x) = \frac{1}{\sqrt{2\pi}\sigma} e^{-(x - \mu)^2/(2 \sigma^2)}}{%
           f(x) = 1/(\sqrt(2\pi)\sigma) e^(-(x - \mu)^2/(2 \sigma^2))}
}\if{html}{\out{</div>}}

for \eqn{-\infty < x < \infty} and \eqn{\sigma > 0}, where \eqn{\mu} is the
mean of the distribution and \eqn{\sigma} the standard deviation.
}
\examples{
 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qnorm
 vnorm(3, mean = 2, sd = 1)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qnorm
 vnorm(3, 10, 2, stream = 1)
 vnorm(3, 10, 2, stream = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qnorm
 vnorm(1, 10, 2, stream = 1)
 vnorm(1, 10, 2, stream = 2)
 vnorm(1, 10, 2, stream = 1)
 vnorm(1, 10, 2, stream = 2)
 vnorm(1, 10, 2, stream = 1)
 vnorm(1, 10, 2, stream = 2)

 set.seed(8675309)
 variates <- vnorm(100, 10, 2, stream = 1)
 set.seed(8675309)
 variates <- vnorm(100, 10, 2, stream = 1, antithetic = TRUE)

}
\seealso{
\code{\link[rstream]{rstream}}, \code{\link{set.seed}},
\code{\link[=runif]{stats::runif}}

\code{\link[=rnorm]{stats::rnorm}}
}
\author{
Barry Lawson (\email{blawson@bates.edu}), \cr
Larry Leemis (\email{leemis@math.wm.edu}), \cr
Vadim Kudlay (\email{vkudlay@nvidia.com})
}
\concept{random variate generation}
\keyword{distribution}
