% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated-funs.R
\name{silv_volume}
\alias{silv_volume}
\title{Calculate Tree Volume}
\usage{
silv_volume(
  diameter_base = NULL,
  diameter_top = NULL,
  diameter_center = NULL,
  diameter = NULL,
  height = NULL,
  formula = "pressler",
  ntrees = NULL
)
}
\arguments{
\item{diameter_base}{A numeric vector. The diameter at the base of the tree
(required for Pressler, Smalian, and Newton formulas).}

\item{diameter_top}{A numeric vector. The diameter at the top of the tree
(required for Smalian and Newton formulas).}

\item{diameter_center}{A numeric vector. The diameter at the center of the
tree (required for Huber and Newton formulas).}

\item{diameter}{A numeric vector. The diameter at breast height (used in
Pressler formula if provided instead of \code{diameter_base}).}

\item{height}{A numeric vector. The tree or log height (required for all formulas).}

\item{formula}{Character. The volume formula to use. Options: \code{"pressler"},
\code{"huber"}, \code{"smalian"}, \code{"newton"}. Default is \code{"pressler"}.}

\item{ntrees}{A numeric vector with number of trees of the same dimensions.
Default is 1.}
}
\value{
A numeric value representing the tree volume.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function calculates the volume of a tree or logs using different formulas:
Pressler, Huber, Smalian, and Newton. The appropriate diameter and height
parameters must be provided depending on the selected formula.
}
\examples{
silv_volume(diameter_base = 30, height = 20, formula = "pressler")
silv_volume(diameter_center = 25, height = 15, formula = "huber")
silv_volume(diameter_base = 30, diameter_top = 20, height = 20, formula = "smalian")

}
