% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sv_importance.R
\name{format_max}
\alias{format_max}
\title{Number Formatter}
\usage{
format_max(x, digits = 4L, ...)
}
\arguments{
\item{x}{A numeric vector to be formatted.}

\item{digits}{Number of significant digits of the largest absolute value.}

\item{...}{Further arguments passed to \code{\link[=format]{format()}}, e.g., \code{big.mark = "'"}.}
}
\value{
A character vector of formatted numbers.
}
\description{
Formats a numeric vector in a way that its largest absolute value determines
the number of digits after the decimal separator. This function is helpful in
perfectly aligning numbers on plots. Does not use scientific formatting.
}
\examples{
x <- c(100, 1, 0.1)
format_max(x)

y <- c(100, 1.01)
format_max(y)
format_max(y, digits = 5)
}
