% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mahalanobis_distance_cpp}
\alias{mahalanobis_distance_cpp}
\title{(Generalized) Mahalanobis distance}
\usage{
mahalanobis_distance_cpp(
  featureList,
  Xtrain_mat,
  Xexplain_mat,
  mcov,
  S_scale_dist
)
}
\arguments{
\item{featureList}{List.
Contains the vectors indicating all factor combinations that should be included in the computations.
Assumes that the first one is empty.}

\item{Xtrain_mat}{Matrix
Training data in matrix form}

\item{Xexplain_mat}{Matrix
Explanation data in matrix form.}

\item{mcov}{matrix
The covariance matrix of X.}

\item{S_scale_dist}{logical.
Indicating whether the Mahalanobis distance should be scaled with the number of variables}
}
\value{
Array of three dimensions. Contains the squared distance for between all training and test observations for all feature combinations passed to the function.
}
\description{
Used to get the Euclidean distance as well by setting \code{mcov} = \code{diag(m)}.
}
\author{
Martin Jullum
}
\keyword{internal}
