% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymmetric_and_causal_Shapley.R
\name{get_S_causal_steps}
\alias{get_S_causal_steps}
\title{Get the steps for generating MC samples for coalitions following a causal ordering}
\usage{
get_S_causal_steps(S, causal_ordering, confounding, as_string = FALSE)
}
\arguments{
\item{S}{Integer matrix of dimension \code{n_coalitions_valid x m}, where \code{n_coalitions_valid} equals
the total number of valid coalitions that respect the causal ordering given in \code{causal_ordering} and \code{m} equals
the total number of features.}

\item{causal_ordering}{List.
Not applicable for (regular) non-causal or asymmetric explanations.
\code{causal_ordering} is an unnamed list of vectors specifying the components of the
partial causal ordering that the coalitions must respect. Each vector represents
a component and contains one or more features/groups identified by their names
(strings) or indices (integers). If \code{causal_ordering} is \code{NULL} (default), no causal
ordering is assumed and all possible coalitions are allowed. No causal ordering is
equivalent to a causal ordering with a single component that includes all features
(\code{list(1:n_features)}) or groups (\code{list(1:n_groups)}) for feature-wise and group-wise
Shapley values, respectively. For feature-wise Shapley values and
\code{causal_ordering = list(c(1, 2), c(3, 4))}, the interpretation is that features 1 and 2
are the ancestors of features 3 and 4, while features 3 and 4 are on the same level.
Note: All features/groups must be included in \code{causal_ordering} without duplicates.}

\item{confounding}{Logical vector.
Not applicable for (regular) non-causal or asymmetric explanations.
\code{confounding} is a logical vector specifying whether confounding is assumed for each component in the
\code{causal_ordering}. If \code{NULL} (default), no assumption about the confounding structure is made and \code{explain}
computes asymmetric/symmetric conditional Shapley values, depending on \code{asymmetric}.
If \code{confounding} is a single logical (\code{FALSE} or \code{TRUE}), the assumption is set globally
for all components in the causal ordering. Otherwise, \code{confounding} must have the same
length as \code{causal_ordering}, indicating the confounding assumption for each component. When \code{confounding} is
specified, \code{explain} computes asymmetric/symmetric causal Shapley values, depending on \code{asymmetric}.
The \code{approach} cannot be \code{regression_separate} or \code{regression_surrogate}, as the
regression-based approaches are not applicable to the causal Shapley methodology.}

\item{as_string}{Boolean.
If the returned object is to be a list of lists of integers or a list of vectors of strings.}
}
\value{
Depends on the value of the parameter \code{as_string}. If a string, then \code{results[j]} is a vector specifying
the process of generating the samples for coalition \code{j}. The length of \code{results[j]} is the number of steps, and
\code{results[j][i]} is a string of the form \code{features_to_sample|features_to_condition_on}. If the
\code{features_to_condition_on} part is blank, then we are to sample from the marginal distribution.
For \code{as_string == FALSE}, then we rather return a vector where \code{results[[j]][[i]]} contains the elements
\code{Sbar} and \code{S} representing the features to sample and condition on, respectively.
}
\description{
Get the steps for generating MC samples for coalitions following a causal ordering
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
