% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sftime.R
\name{print.sftime}
\alias{print.sftime}
\title{Prints an \code{sftime} object}
\usage{
\method{print}{sftime}(x, ..., n = getOption("sf_max_print", default = 10))
}
\arguments{
\item{x}{An object of class \code{sftime}.}

\item{...}{Currently unused arguments, for compatibility.}

\item{n}{Numeric value; maximum number of printed elements.}
}
\value{
\code{x} (invisible).
}
\description{
Prints an \code{sftime} object
}
\examples{
g <- st_sfc(st_point(c(1, 2)), st_point(c(1, 3)), st_point(c(2, 3)), 
     st_point(c(2, 1)), st_point(c(3, 1)))
tc <- Sys.time() + 1:5
x <- st_sftime(a = 1:5, g, time = tc)
print(x)
print(x[0, ])

}
