% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_grid.R
\name{hotspot_grid}
\alias{hotspot_grid}
\title{Create either a rectangular or hexagonal two-dimensional grid}
\usage{
hotspot_grid(data, cell_size = NULL, grid_type = "rect", quiet = FALSE, ...)
}
\arguments{
\item{data}{\code{\link[sf]{sf}} data frame.}

\item{cell_size}{\code{numeric} value specifying the size of each equally
spaced grid cell, using the same units (metres, degrees, etc.) as used in
the \code{sf} data frame given in the \code{data} argument. If this
argument is \code{NULL} (the default), the cell size will be calculated
automatically (see Details).}

\item{grid_type}{\code{character} specifying whether the grid should be made
up of squares (\code{"rect"}, the default) or hexagons (\code{"hex"}).}

\item{quiet}{if set to \code{TRUE}, messages reporting the values of any
parameters set automatically will be suppressed. The default is
\code{FALSE}.}

\item{...}{Further arguments passed to \code{link[sf]{st_make_grid}}.}
}
\value{
A simple features tibble containing polygons representing grid cells.

The grid will be based on the convex hull of \code{data}, expanded by a
buffer of \code{cell_size / 2} to ensure all the points in \code{data} fall
within the resulting grid.
}
\description{
Create either a rectangular or hexagonal two-dimensional grid
}
