% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data_documentation.R
\docType{data}
\name{SeqOUT_HSg5}
\alias{SeqOUT_HSg5}
\title{Example output from pedigree inference: 'HSg5'}
\format{
a list, see \code{\link{sequoia}}
}
\usage{
data(SeqOUT_HSg5)
}
\description{
Example output of a \code{\link{sequoia}} run including sibship
  clustering, based on Pedigree \code{\link{Geno_HSg5}}.
}
\examples{
\dontrun{
# this output was created as follows:
Geno <- SimGeno(Ped = Ped_HSg5, nSnp = 200)
SeqOUT_HSg5 <- sequoia(GenoM = Geno, LifeHistData = LH_HSg5, Module = "ped",
                       Err = 0.005)
}
# some ways to inspect the output; see vignette for more info:
names(SeqOUT_HSg5)
SeqOUT_HSg5$Specs
SummarySeq(SeqOUT_HSg5)
}
\seealso{
\code{\link{Ped_HSg5}, \link{LH_HSg5}}
}
\author{
Jisca Huisman, \email{jisca.huisman@gmail.com}
}
\keyword{datasets}
\keyword{sequoia}
