% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindFamilies.R
\name{PedStripFID}
\alias{PedStripFID}
\title{Back-transform IDs}
\usage{
PedStripFID(Ped, FIDsep = "__")
}
\arguments{
\item{Ped}{pedigree as returned by sequoia (e.g. \code{SeqOUT$Pedigree}).}

\item{FIDsep}{characters inbetween FID and IID in composite-ID.}
}
\value{
A pedigree with 6 columns
\item{FID}{family ID of focal individual (offspring).}
\item{id}{within-family of focal individual}
\item{dam.FID}{original family ID of assigned dam}
\item{dam}{within-family of dam}
\item{sire.FID}{original family ID of assigned sire}
\item{sire}{within-family of sire}
}
\description{
Reverse the joining of FID and IID in
\code{\link{GenoConvert}} and \code{\link{LHConvert}}
}
\details{
Note that the family IDs are the ones provided, and not
 automatically updated. New, numeric ones can be obtained with
  \code{\link{FindFamilies}}.
}
