% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stacked_sequence_plot.R
\name{stacked_sequence_plot}
\alias{stacked_sequence_plot}
\title{Stacked Sequence Plots of Multichannel Sequences and/or Most Probable
Paths from Hidden Markov Models}
\usage{
stacked_sequence_plot(
  x,
  plots = "obs",
  type = "distribution",
  ids,
  sort_by = "none",
  sort_channel,
  dist_method = "OM",
  group = NULL,
  legend_position = "right",
  ...
)
}
\arguments{
\item{x}{Either a hidden Markov model object of class \code{hmm}, \code{mhmm}, \code{nhmm},
or \code{mnhmm}, a sequence object of class \code{stslist} (created with the
\code{\link[TraMineR:seqdef]{TraMineR::seqdef()}} function) or a list of \code{stslist} objects.}

\item{plots}{What to plot. One of \code{"obs"} for observations (the default),
\code{"hidden_paths"} for most probable paths of hidden states,
or \code{"both"} for observations and hidden paths together. Latter two options
are only possible for model objects.}

\item{type}{The type of the plot. Available types are \code{"index"} for sequence
index plots and \code{"distribution"} for state distribution plots (the default).
See \code{\link[ggseqplot:ggseqiplot]{ggseqplot::ggseqiplot()}} and \code{\link[ggseqplot:ggseqdplot]{ggseqplot::ggseqdplot()}} for details.}

\item{ids}{Indexes of the subjects to be plotted (the default is all). For
example, `ids = c(1:10, 15) plots the first ten subjects and subject 15 in
the data.}

\item{sort_by}{A sorting variable or a sort method (one of \verb{"none}, \code{"start"},
\code{"end"}, or \code{"mds"} for \code{type = "index"}. Option \code{"mds"} arranges the
sequences according to the scores of multidimensional scaling (using
\code{\link[stats:cmdscale]{stats::cmdscale()}}). Default is \code{"none"}, i.e., no sorting. Numeric vectors
are passed to \code{sortv} argument of \code{\link[ggseqplot:ggseqiplot]{ggseqplot::ggseqiplot()}}.}

\item{sort_channel}{Name of the channel which should be used for the
sorting. Alternatively value \code{"Hidden states"} uses the hidden state
sequences for sorting. Default is to sort by the first channel in the data.
If \code{sort_by = "mds"}, all channels are used for defining the sorting.}

\item{dist_method}{The metric to be used for computing the distances of the
sequences if multidimensional scaling is used for sorting. Default is \code{"OM"}
(optimal matching). For other more information and other options, see
\code{\link[TraMineR:seqdist]{TraMineR::seqdist()}}. Transition rates are used for defining substitution
costs if  needed. Note that not all methods are available for sorting
multichannel data.}

\item{group}{Variable used for grouping the sequences in each channel, which
is passed to \code{\link[ggseqplot:ggseqiplot]{ggseqplot::ggseqiplot()}} and \code{\link[ggseqplot:ggseqdplot]{ggseqplot::ggseqdplot()}}. By
default, no grouping is done, except for mixture models where the grouping
is based on most probable clusters (defined by the most probable hidden
paths). Grouping by clusters can be overloaded by supplying variable for
\code{group} or by setting \code{group = NA}.}

\item{legend_position}{Position of legend for each channel,
passed to \code{legend.position} argument of \code{\link[ggplot2:theme]{ggplot2::theme()}}. Either a vector
of length 1, or of length matching the number of channels to be plotted.}

\item{...}{Other arguments to \code{\link[ggseqplot:ggseqiplot]{ggseqplot::ggseqiplot()}} or
\code{\link[ggseqplot:ggseqdplot]{ggseqplot::ggseqdplot()}}.}
}
\description{
Function \code{stacked_sequence_plot} draws stacked sequence plots of sequence
object created with the \link[TraMineR:seqdef]{TraMineR::seqdef} function or observations and/or most
probable paths of model objects of \code{seqHMM} (e.g., \code{hmm} and \code{mhmm}).
}
\examples{
p <- stacked_sequence_plot(
  mhmm_biofam, 
  plots = "both", 
  type = "d", 
  legend_position = c("right", "right", "right", "none")
)
library("ggplot2")
p & theme(plot.margin = unit(c(1, 1, 0, 2), "mm"))

}
