% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrepancy_ersatz.R
\name{discrepancy_ersatz}
\alias{discrepancy_ersatz}
\title{Computation of the S-ersatz discrepancy.}
\usage{
discrepancy_ersatz(mat, Y, params)
}
\arguments{
\item{mat}{A numeric matrix created with \code{\link{sobol_matrices}} and \code{matrices = "A"},
where each column represents an uncertain model input and each row a model simulation.}

\item{Y}{A numeric vector with the model output obtained from the matrix created with
\code{\link{sobol_matrices}}. The numeric vector should not contain any NA or NaN values.}

\item{params}{A character vector with the name of the model inputs.}
}
\value{
A \code{data.table} object.
}
\description{
It allows to use the S-ersatz discrepancy measure by \insertCite{puy2023_discrepancy;textual}{sensobol}
as a sensitivity measure.
}
\details{
It is recommended to define \code{mat} using a power of 2 as a sample size.
}
\examples{
# Define settings
N <- 2^9; params <- paste("X", 1:8, sep = "")

# Create sample matrix
mat <- sobol_matrices(N = N, params = params, matrices = "A")

# Compute the Sobol' G function
Y <- sobol_Fun(mat)

# Compute the S-ersatz discrepancy values
ind <- discrepancy_ersatz(mat = mat, Y = Y, params = params)
}
\references{
\insertAllCited{}
}
