% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_list_of_lists.R
\name{to_list_of_lists}
\alias{to_list_of_lists}
\title{Convert a named vector to a list of lists}
\usage{
to_list_of_lists(input, name1 = NULL, name2 = NULL, name3 = NULL)
}
\arguments{
\item{input}{A named vector}

\item{name1}{The name for the first element in the list-in-list.
Default is \code{NULL}.}

\item{name2}{The name for the second element in the list-in-list.
Defaultis \code{NULL}.}

\item{name3}{The name for the third element in the list-in-list.
Default is \code{NULL}. If this argument is not \code{NULL}, the names of the
vector elements will be split using \code{lavaan} syntax (by calling
\code{\link[lavaan:model.syntax]{lavaan::lavParseModelString()}}), and the right-hand side (\code{rhs})
and left-hand side (\code{lhs}) of each element will be assigned to
\code{name1} and \code{name2}, respectively.}
}
\value{
A list of lists.
}
\description{
Convert a named vector to a list of lists, to be used
by various functions in \code{\link{semptools}}.
}
\details{
This function is not to be used by users, but to be used
internally by other functions of \code{\link{semptools}}.
}
\examples{
x <- c("x1 ~~ x2" = -1, "x4 ~ x1" = 1)
to_list_of_lists(x, name1 = "from", name2 = "to", name3 = "new_curve")
#list(list(from = "x1", to = "x2", new_curve = -1),
#     list(from = "x1", to = "x4", new_curve =  1))

y <- c(x1 = 0, x2 = 180, x3 = 140, x4 = 140)
to_list_of_lists(y, name1 = "node", name2 = "rotate")
#list(list(node = "x1", rotate =   0),
#     list(node = "x2", rotate = 180),
#     list(node = "x3", rotate = 140),
#     list(node = "x4", rotate = 140))

}
