% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_edge_label_position.R
\name{set_edge_label_position}
\alias{set_edge_label_position}
\title{Set the positions of edge labels of selected edges}
\usage{
set_edge_label_position(semPaths_plot, position_list = NULL)
}
\arguments{
\item{semPaths_plot}{A \link[qgraph:qgraph]{qgraph::qgraph} object generated by
\link[semPlot:semPaths]{semPlot::semPaths}, or a similar qgraph object modified by other
\link{semptools} functions.}

\item{position_list}{A named vector or a list of named lists. For a
named vector, the name of an element should be the path as
specified by \link[lavaan:model.syntax]{lavaan::model.syntax} or as appeared in
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}. For example, to change position of
the edge label of the path regressing \code{y} on \code{x}, the name should
be \code{"y ~ x"}. The value is the position. The mid-point of the edge
is 0.5. The closer the value to 1, the closer the label to the
left-hand-side node (\code{y} in this example). The closer the value to
0, the close the label to the right-hand-side node (\code{x} in this
example). For example, \code{c("y ~ x1" = .2, "y ~ x2" = .7)} moves the
path coefficient from \code{x1} to \code{y} closer to \code{x}, and the path
coefficient from \code{x2} to \code{y} closer to \code{y}. For a list of named
lists, each named list should have three named values: \code{from},
\code{to}, and \code{new_position}. The edge label position of the edge from
\code{from} to \code{to} will be set to \code{new_position}. For example,
\code{list(list(from = "x1", to = "y", new_position = .2), list(from = "x2", to = "y", new_position = .7))} is equivalent to the named
vector above.}
}
\value{
A \link[qgraph:qgraph]{qgraph::qgraph} based on the original one, with edge
label positions for selected edges changed.
}
\description{
Set the positions of edge labels of selected edges.
}
\details{
Modify a \link[qgraph:qgraph]{qgraph::qgraph} object generated by
\link[semPlot:semPaths]{semPlot::semPaths} and change the edge label positions of selected
edges.
}
\examples{
mod_pa <-
 'x1 ~~ x2
  x3 ~  x1 + x2
  x4 ~  x1 + x3
 '
fit_pa <- lavaan::sem(mod_pa, pa_example)
lavaan::parameterEstimates(fit_pa)[, c("lhs", "op", "rhs", "est", "pvalue")]
m <- matrix(c("x1",   NA,   NA,
               NA, "x3", "x4",
             "x2",   NA,   NA), byrow = TRUE, 3, 3)
p_pa <- semPlot::semPaths(fit_pa, whatLabels="est",
           style = "ram",
           nCharNodes = 0, nCharEdges = 0,
           layout = m)

my_position_vector <- c("x3 ~ x2" = .25,
                       "x4 ~ x1" = .75)
p_pa2v <- set_edge_label_position(p_pa, my_position_vector)
plot(p_pa2v)

my_position_list <- list(list(from = "x2", to = "x3", new_position =  .25),
                       list(from = "x1", to = "x4", new_position =  .75))
p_pa2l <- set_edge_label_position(p_pa, my_position_list)
plot(p_pa2l)

}
