% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.check_dag.R
\name{plot.see_check_dag}
\alias{plot.see_check_dag}
\title{Plot method for check DAGs}
\usage{
\method{plot}{see_check_dag}(
  x,
  size_point = 20,
  size_text = 4.5,
  colors = NULL,
  which = "all",
  effect = "total",
  check_colliders = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{check_dag} object.}

\item{size_point}{Numeric value specifying size of point geoms.}

\item{size_text}{Numeric value specifying size of text elements.}

\item{colors}{Character vector of length five, indicating the colors (in
hex-format) for different types of variables, which are assigned in following
order: \code{outcome}, \code{exposure}, \code{adjusted}, \code{unadjusted}, and \code{collider}.}

\item{which}{Character string indicating which plot to show. Can be either
\code{"all"}, \code{"current"} or \code{"required"}.}

\item{effect}{Character string indicating which effect for the required model
is to be estimated. Can be either \code{"total"} or \code{"direct"}.}

\item{check_colliders}{Logical indicating whether to highlight colliders.
Set to \code{FALSE} if the algorithm to detect colliders is very slow.}

\item{...}{Currently not used.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{performance::check_dag()} function.
}
\examples{
\dontshow{if (require("ggdag", quietly = TRUE)) withAutoprint(\{ # examplesIf}
library(performance)
# incorrect adjustment
dag <- check_dag(
  y ~ x + b + c,
  x ~ b,
  outcome = "y",
  exposure = "x"
)
dag
plot(dag)

# plot only model with required adjustments
plot(dag, which = "required")

# collider-bias?
dag <- check_dag(
  y ~ x + c + d,
  x ~ c + d,
  b ~ x,
  b ~ y,
  outcome = "y",
  exposure = "x",
  adjusted = "c"
)
plot(dag)

# longer labels, automatic detection of outcome and exposure
dag <- check_dag(
  QoL ~ age + education + gender,
  age ~ education
)
plot(dag)
\dontshow{\}) # examplesIf}
}
