% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{term_effectiveness}
\alias{term_effectiveness}
\title{Analyze Term Effectiveness in Search Results}
\usage{
term_effectiveness(
  terms,
  search_results,
  gold_standard = NULL,
  text_fields = c("title", "abstract")
)
}
\arguments{
\item{terms}{Character vector of search terms to analyze}

\item{search_results}{Data frame with search results}

\item{gold_standard}{Optional vector of relevant article IDs}

\item{text_fields}{Character vector of column names to search for terms (default: c("title", "abstract"))}
}
\value{
Data frame with term effectiveness metrics
}
\description{
Analyzes the effectiveness of individual search terms by calculating precision,
coverage, and other relevant metrics for each term. This provides insight into
which terms are most effective at retrieving relevant articles.
}
\details{
For each term, this function calculates:
\itemize{
\item Number of articles containing the term
\item Number of relevant articles containing the term (if gold_standard provided)
\item Precision (proportion of retrieved articles that are relevant)
\item Coverage (proportion of relevant articles retrieved by the term)
}
}
\examples{
# Create sample data
search_results <- data.frame(
  id = paste0("art", 1:10),
  title = c("Diabetes treatment", "Clinical trial", "Diabetes study",
            "Treatment options", "New therapy", "Glucose control",
            "Insulin therapy", "Management of diabetes", "Clinical study",
            "Therapy comparison"),
  abstract = c("This study examines diabetes treatments.",
               "A clinical trial on new treatments.",
               "Diabetes research findings.",
               "Comparison of treatment options.",
               "Novel therapy approach.",
               "Methods to control glucose levels.",
               "Insulin therapy effectiveness.",
               "Managing diabetes effectively.",
               "Clinical research protocols.",
               "Comparing therapy approaches.")
)

# Define search terms
terms <- c("diabetes", "treatment", "clinical", "therapy")

# Define gold standard (relevant articles)
gold_standard <- c("art1", "art3", "art7", "art8")

# Analyze term effectiveness
term_metrics <- term_effectiveness(terms, search_results, gold_standard)
print(term_metrics)

}
