% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-utilities.R
\name{export_validation}
\alias{export_validation}
\title{Export Validation Results}
\usage{
export_validation(validation_results, file_path, format = "xlsx")
}
\arguments{
\item{validation_results}{Results from benchmark validation}

\item{file_path}{Output file path}

\item{format}{Export format ("xlsx", "csv", "json")}
}
\value{
File path of created file
}
\description{
Export Validation Results
}
\examples{
# Create sample validation results
validation_results <- list(
  precision = 0.8,
  recall = 0.6,
  f1_score = 0.69,
  true_positives = 24,
  false_positives = 6,
  false_negatives = 16
)

# Export validation results (writes to tempdir())
output_file <- export_validation(
  validation_results,
  file.path(tempdir(), "validation.xlsx")
)
print(output_file)
}
