% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-utilities.R
\name{create_data_package}
\alias{create_data_package}
\title{Create Data Package for Sharing}
\usage{
create_data_package(
  search_results,
  analysis_results = NULL,
  output_dir = NULL,
  package_name = "search_analysis_package"
)
}
\arguments{
\item{search_results}{Data frame with search results}

\item{analysis_results}{List of analysis results}

\item{output_dir}{Directory to create the package (defaults to tempdir())}

\item{package_name}{Name of the package}
}
\value{
Path to created package directory
}
\description{
Create Data Package for Sharing
}
\examples{
# Create sample data
search_results <- data.frame(
  id = paste0("art", 1:10),
  title = paste("Study", 1:10),
  abstract = paste("Abstract", 1:10),
  source = "Journal",
  date = Sys.Date(),
  stringsAsFactors = FALSE
)

# Create data package (writes to tempdir())
package_path <- create_data_package(search_results)
print(package_path)
}
