% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubmed-connector.R
\name{PubMedConnector}
\alias{PubMedConnector}
\title{PubMed Database Connector}
\description{
A class for connecting to and searching PubMed database directly,
then formatting results for analysis with searchAnalyzeR.
}
\details{
This module provides functionality to search PubMed directly and integrate
the results with searchAnalyzeR's analysis capabilities.
PubMed Search Interface

This class uses the rentrez package to interface with NCBI's E-utilities
to search PubMed and retrieve article metadata. Results are automatically
formatted for use with SearchAnalyzer. If rentrez is not available,
it provides simulated data for demonstration purposes.
}
\section{Methods}{

\describe{
\item{\code{new()}}{Initialize a new PubMedConnector instance}
\item{\code{search(query, max_results, date_range)}}{Search PubMed database}
\item{\code{get_details(pmids)}}{Get detailed information for specific PMIDs}
\item{\code{format_for_analysis()}}{Format results for SearchAnalyzer}
}
}

\examples{
\donttest{
# Create PubMed connector
pubmed <- PubMedConnector$new()

# Search for diabetes studies
results <- pubmed$search(
  query = "diabetes[Title/Abstract] AND clinical trial[Publication Type]",
  max_results = 100,
  date_range = c("2020/01/01", "2023/12/31")
)

# Format for analysis
search_data <- pubmed$format_for_analysis()

# Use with SearchAnalyzer
analyzer <- SearchAnalyzer$new(search_data)
metrics <- analyzer$calculate_metrics()
}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{last_search_results}}{Raw results from last search}

\item{\code{formatted_results}}{Formatted results ready for analysis}

\item{\code{search_metadata}}{Metadata about the last search}

\item{\code{use_simulation}}{Flag indicating if simulation mode is active}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PubMedConnector-new}{\code{PubMedConnector$new()}}
\item \href{#method-PubMedConnector-search}{\code{PubMedConnector$search()}}
\item \href{#method-PubMedConnector-get_details}{\code{PubMedConnector$get_details()}}
\item \href{#method-PubMedConnector-format_for_analysis}{\code{PubMedConnector$format_for_analysis()}}
\item \href{#method-PubMedConnector-get_search_summary}{\code{PubMedConnector$get_search_summary()}}
\item \href{#method-PubMedConnector-clone}{\code{PubMedConnector$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PubMedConnector-new"></a>}}
\if{latex}{\out{\hypertarget{method-PubMedConnector-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new PubMedConnector instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PubMedConnector$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
No return value, called for side effects
Search PubMed database
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PubMedConnector-search"></a>}}
\if{latex}{\out{\hypertarget{method-PubMedConnector-search}{}}}
\subsection{Method \code{search()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PubMedConnector$search(
  query,
  max_results = 100,
  date_range = NULL,
  retmode = "xml"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{PubMed search query string}

\item{\code{max_results}}{Maximum number of results to retrieve (default: 100)}

\item{\code{date_range}}{Optional date range as c("YYYY/MM/DD", "YYYY/MM/DD")}

\item{\code{retmode}}{Return mode ("xml" or "text")}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Number of results found
Get detailed information for specific PMIDs
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PubMedConnector-get_details"></a>}}
\if{latex}{\out{\hypertarget{method-PubMedConnector-get_details}{}}}
\subsection{Method \code{get_details()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PubMedConnector$get_details(pmids, retmode = "xml")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pmids}}{Vector of PubMed IDs}

\item{\code{retmode}}{Return mode ("xml" or "text")}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Detailed article information
Format results for SearchAnalyzer
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PubMedConnector-format_for_analysis"></a>}}
\if{latex}{\out{\hypertarget{method-PubMedConnector-format_for_analysis}{}}}
\subsection{Method \code{format_for_analysis()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PubMedConnector$format_for_analysis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Data frame formatted for searchAnalyzeR analysis
Get search summary
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PubMedConnector-get_search_summary"></a>}}
\if{latex}{\out{\hypertarget{method-PubMedConnector-get_search_summary}{}}}
\subsection{Method \code{get_search_summary()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PubMedConnector$get_search_summary()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List with search summary information
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PubMedConnector-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PubMedConnector-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PubMedConnector$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
