% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{setRisk_cpp}
\alias{setRisk_cpp}
\title{Calculate Risk}
\usage{
setRisk_cpp(data, hierarchy, risk_variables, hid)
}
\arguments{
\item{data}{micro data set containing only numeric values.}

\item{hierarchy}{column indices of variables in \code{data} which refere to the geographic hierarchy in the micro data set. For instance county > municipality > district.}

\item{risk_variables}{column indices of variables in \code{data} which will be considered for estimating the risk.}

\item{hid}{column index in \code{data} which refers to the household identifier.}
}
\description{
Calculate risk for records to be swapped and donor records.  Risks are defined by 1/counts, where counts is the number of records with the same values for specified \code{risk_variables} in the each geographic hierarchy.
This risk will be used as sampling probability for both sampling set and donor set.
\cr
\strong{NOTE:} This is an internal function used for testing the C++-function \code{setRisk} which is used inside the C++-function \code{recordSwap()}.
}
