% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muargus_compatibility_functions.R
\name{argus_rankswap}
\alias{argus_rankswap}
\title{argus_rankswap}
\usage{
argus_rankswap(df, perc)
}
\arguments{
\item{df}{a \code{data.frame} with only numerical columns}

\item{perc}{a number defining the swapping percantage}
}
\value{
a \code{list} with two elements
\itemize{
\item{original: } the originally provided input data
\item{swapped: } the \code{data.frame} containing the swapped values
}
}
\description{
argus_rankswap
}
\examples{
mat <- matrix(sample(1:100, 50, replace=TRUE), nrow=10, ncol=5)
df <- as.data.frame(mat)
res <- argus_rankswap(df, perc=10)
}
\seealso{
mu-Argus manual at \url{https://github.com/sdcTools/manuals/raw/master/mu-argus/MUmanual5.1.pdf}
}
