% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocalRecProg.R
\docType{methods}
\name{LocalRecProg}
\alias{LocalRecProg}
\title{Local recoding via Edmond's maximum weighted matching algorithm}
\usage{
LocalRecProg(
  obj,
  ancestors = NULL,
  ancestor_setting = NULL,
  k_level = 2,
  FindLowestK = TRUE,
  weight = NULL,
  lowMemory = FALSE,
  missingValue = NA,
  ...
)
}
\arguments{
\item{obj}{a \code{data.frame} or a \code{\link{sdcMicroObj-class}}-object}

\item{ancestors}{Names of ancestors of the cateorical variables}

\item{ancestor_setting}{For each ancestor the corresponding categorical variable}

\item{k_level}{Level for k-anonymity}

\item{FindLowestK}{requests the program to look for the smallest k that
results in complete matches of the data.}

\item{weight}{A weight for each variable (Default=1)}

\item{lowMemory}{Slower algorithm with less memory consumption}

\item{missingValue}{The output value for a suppressed value.}

\item{...}{see arguments below
\describe{
\item{categorical}{Names of categorical variables}
\item{numerical}{Names of numerical variables}}}
}
\value{
dataframe with original variables and the supressed variables
(suffix _lr). / the modified \code{\link{sdcMicroObj-class}}
}
\description{
To be used on both categorical and numeric input variables, although usage
on categorical variables is the focus of the development of this software.
}
\details{
Each record in the data represents a category of the original data, and
hence all records in the input data should be unique by the N Input
Variables. To achieve bigger category sizes (k-anoymity), one can form new
categories based on the recoding result and repeatedly apply this algorithm.
}
\section{Methods}{
 \describe{
\item{list("signature(obj=\"sdcMicroObj\")")}{}}
}

\examples{
data(testdata2)
cat_vars <- c("urbrur", "roof", "walls", "water", "sex", "relat")
anc_var <- c("water2", "water3", "relat2")
anc_setting <- c("water","water","relat")
\donttest{
r1 <- LocalRecProg(
  obj = testdata2,
  categorical = cat_vars,
  missingValue = -99)
r2 <- LocalRecProg(
  obj = testdata2,
  categorical = cat_vars,
  ancestor = anc_var,
  ancestor_setting = anc_setting,
  missingValue = -99)
r3 <- LocalRecProg(
  obj = testdata2,
  categorical = cat_vars,
  ancestor = anc_var,
  ancestor_setting = anc_setting,
  missingValue = -99,
  FindLowestK = FALSE)

# for objects of class sdcMicro:
sdc <- createSdcObj(
  dat = testdata2,
  keyVars = c("urbrur", "roof", "walls", "water", "electcon", "relat", "sex"),
  numVars = c("expend", "income", "savings"),
  w = "sampling_weight")
sdc <- LocalRecProg(sdc)
}
}
\references{
Kowarik, A. and Templ, M. and Meindl, B. and Fonteneau, F. and Prantner, B.:
\emph{Testing of IHSN Cpp Code and Inclusion of New Methods into sdcMicro},
in: Lecture Notes in Computer Science, J. Domingo-Ferrer, I. Tinnirello
(editors.); Springer, Berlin, 2012, ISBN: 978-3-642-33626-3, pp. 63-77.
\doi{10.1007/978-3-642-33627-0_6}
}
\author{
Alexander Kowarik, Bernd Prantner, IHSN C++ source, Akimichi Takemura
}
\keyword{manip}
