% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{jaccard_indicator}
\alias{jaccard_indicator}
\title{Compute indicator matrix of pairwise distances smaller than threshold}
\usage{
jaccard_indicator(x, upper_bnd = 0.8)
}
\arguments{
\item{x}{the input matrix with vectors to be compared in the rows.}

\item{upper_bnd}{pairs with a Jaccard distance below this upper bound are
returned as 1 while all others receive the entry 0.}
}
\value{
A list of vectors describing a sparse lower triangular pattern matrix
\item{i}{Row indices}
\item{j}{Column indices}
}
\description{
Computes the Jaccard distance between rows of a matrix and returns a
sparse symmetric indicator matrix containing the entries with a distance
of less than a given upper bound. Note that the diagonal is always 1.
}
\keyword{internal}
