% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screenshot.R
\name{install_screenshot}
\alias{install_screenshot}
\title{Install command line screenshot for Windows.}
\usage{
install_screenshot(bin_dir = "")
}
\arguments{
\item{bin_dir}{A string of directory to be installed.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   A string of installed directory.
}\if{html}{\out{</div>}}
}
\description{
Codes are from URL shown below.
https://superuser.com/questions/75614/take-a-screen-shot-from-command-line-in-windows#answer-1751844
On Mac \code{screencapture} is usually available.
On Linux GNOME desktop use \code{gnome-screenshot}.
If not installed, run \verb{sudo apt install gnome-screenshot}.
}
\examples{
if(interactive()){

# need only on Win
if(get_os() == "win"){
  bin_dir <- fs::path_package("screenshot")
  # if you want to install another directory
  #   bin_dir <- "SET_YOUR DIRECTORY"
  install_screenshot(bin_dir)
}

}

}
