% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRR.R
\name{calc_SRRpars}
\alias{calc_SRRpars}
\title{Convert density-dependent survival parameters}
\usage{
calc_SRRpars(p, capacity, f = 1, p_female = 1, type = c("BH", "Ricker", "HS"))
}
\arguments{
\item{p}{Numeric, the productivity parameter that sets the maximum survival as the initial abundance approaches zero}

\item{capacity}{Numeric, the capacity parameter that set the maximum survivors}

\item{f}{Fecundity, the spawning output per mature female}

\item{p_female}{The proportion of females per spawner}

\item{type}{Character, the functional form of the stock-recruit relationship}
}
\value{
Numeric vector length 2 for alpha and beta value, respectively
}
\description{
Converts from capacity/productivity parameters to alpha/beta stock-recruit parameters where productivity is in terms
of smolts per spawner and alpha is terms of smolts per egg.
}
\details{
\deqn{\alpha = \dfrac{P}{f \times p_{female}}}

For the Beverton-Holt stock recruit relationship:
\deqn{\beta = \dfrac{\alpha}{C}}

For the Ricker stock recruit relationship:
\deqn{\beta = \dfrac{\alpha}{Ce}}, \eqn{e} is Euler's number.
}
\seealso{
\code{\link[=calc_SRR]{calc_SRR()}}
}
