% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore.R
\name{explore}
\alias{explore}
\title{Exploration of the Data Used for Modeling}
\usage{
explore(formula, CV = NULL, data, normality = FALSE)
}
\arguments{
\item{formula}{Optional formula to specify a response variable (e.g., y ~ x1 + x2).}

\item{CV}{Coefficient of Variation (CV) or Relative Standard Error (RSE) of the response variable}

\item{data}{The dataframe to be explored}

\item{normality}{Logical; if \code{TRUE}, the function will additionally check
the normality of the response variable and display the result. Defaults to \code{FALSE}.}
}
\value{
Prints a data frame of summary statistics for the selected
variables, including minimum, 1st quartile, median, mean, 3rd quartile, maximum,
and number of missing values (NA). Plots are drawn to the current graphics device.
}
\description{
Function \code{explore} provides an initial exploration of a dataset. It calculate summary statistics for all variables in the provided formula or dataset,
visualizes the distribution of the response variable as a histogram density,and boxplot for Coefficient of Variation (CV) / Relative Standard Error (RSE).
}
\examples{
dataBeta$CV <- sqrt(dataBeta$vardir)/dataBeta$y
explore(y~X1+X2, CV = "CV", data = dataBeta)

}
