% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RatioRMS.R
\name{RatioRMS}
\alias{RatioRMS}
\title{Compute the ratio between the RMSE of two experiments}
\usage{
RatioRMS(exp1, exp2, obs, time_dim = "sdate", pval = TRUE, ncores = NULL)
}
\arguments{
\item{exp1}{A numeric array with named dimensions of the first experimental 
data. It must have at least 'time_dim' and have the same dimensions as
'exp2' and 'obs'.}

\item{exp2}{A numeric array with named dimensions of the second experimental 
data. It must have at least 'time_dim' and have the same dimensions as 
'exp1' and 'obs'.}

\item{obs}{A numeric array with named dimensions of the observational data.
It must have at least 'time_dim' and have the same dimensions as 'exp1' and
'exp2'.}

\item{time_dim}{A character string of the dimension name along which RMS is
computed. The default value is 'sdate'.}

\item{pval}{A logical value indicating whether to compute the p-value of Ho:
RMSE1/RMSE2 = 1 or not. The default value is TRUE.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list containing the numeric arrays with dimensions identical with
 'exp1', 'exp2', and 'obs', except 'time_dim':
\item{$ratiorms}{
 The ratio between the RMSE (i.e., RMSE1/RMSE2).
}
\item{$p.val}{
 The p-value of the two-sided Fisher test with Ho: RMSE1/RMSE2 = 1. Only 
 exists if 'pval' is TRUE.
}
}
\description{
Calculate the ratio of the RMSE for two forecasts with the same observation,
that is, RMSE(ens, obs) / RMSE(ens.ref, obs). The p-value is provided by a 
two-sided Fischer test.
}
\examples{
startDates <- c('19851101', '19901101', '19951101', '20001101', '20051101')
sampleData <- LoadSampleData(startDates, output = 'lonlat')

# Compute DJF seasonal means and anomalies.
initial_month <- 11
mean_start_month <- 12
mean_stop_month <- 2                                
sampleData$mod <- Season(sampleData$mod, monini = initial_month, 
                         moninf = mean_start_month, monsup = mean_stop_month)
sampleData$obs <- Season(sampleData$obs, monini = initial_month, 
                         moninf = mean_start_month, monsup = mean_stop_month)
clim <- Clim(sampleData$mod, sampleData$obs)
ano_exp <- Ano(sampleData$mod, clim$clim_exp)
ano_obs <- Ano(sampleData$obs, clim$clim_obs)
# Generate two experiments with 2 and 1 members from the only experiment 
# available in the sample data. Take only data values for a single forecast
# time step.
ano_exp_1 <- ClimProjDiags::Subset(ano_exp, 'member', c(1, 2))
ano_exp_2 <- ClimProjDiags::Subset(ano_exp, 'member', c(3))
ano_exp_1 <- ClimProjDiags::Subset(ano_exp_1, c('dataset', 'ftime'),
                                   list(1, 1), drop = 'selected')
ano_exp_2 <- ClimProjDiags::Subset(ano_exp_2, c('dataset', 'ftime'),
                                   list(1, 1), drop = 'selected')
ano_obs <- ClimProjDiags::Subset(ano_obs, c('dataset', 'ftime'), list(1, 1), drop = 'selected')
# Compute ensemble mean and provide as inputs to RatioRMS.
rrms <- RatioRMS(MeanDims(ano_exp_1, 'member'), 
                 MeanDims(ano_exp_2, 'member'), 
                 MeanDims(ano_obs, 'member'))
# Plot the RatioRMS for the first forecast time step.
\donttest{
PlotEquiMap(rrms$ratiorms, sampleData$lon, sampleData$lat, 
            toptitle = 'Ratio RMSE')
}

}
