% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoadSampleData.R
\name{LoadSampleData}
\alias{LoadSampleData}
\title{Load Sample Data for Package Examples}
\usage{
LoadSampleData(sdates, leadtimemin = 1, leadtimemax = NULL, output = "areave")
}
\arguments{
\item{sdates}{Character vector of start dates to include (e.g., 
\code{c("19851101", "19901101")}). Must match one or more of the available 
dates in the internal sample datasets: "19851101", "19901101", "19951101", 
"20001101" or "20051101".}

\item{leadtimemin}{Integer specifying the first lead time to include. Default
is 1.}

\item{leadtimemax}{Integer specifying the last lead time to include. If NULL, 
the full lead time range is included. Default is NULL.}

\item{output}{Character string indicating the type of output: \code{"areave"}
for area-averaged time series data, or \code{"lonlat"} for gridded spatial 
data. Default is \code{"areave"}.}
}
\value{
A named list with the following elements:
\item{mod}{Array of model data with the selected start dates and lead times.}
\item{obs}{Array of observational data with the selected start dates and lead
 times.}
\item{lat}{Vector of latitudes.}
\item{lon}{Vector of longitudes.}
}
\description{
Loads and subsets sample data stored in the internal datasets 
\code{sampleMap} and \code{sampleTimeSeries}, included with the package. 
Intended for use in documentation examples instead of \code{Load()}, in order
to avoid reliance on external system dependencies like 'nco' and 'cdo' and 
to reduce computation time during CRAN checks.
}
\details{
This function is designed for use in examples and tests within the 
's2dv' package. It provides quick access to precomputed datasets, helping to 
avoid slow or system-dependent operations during automated checks.
}
\examples{
startDates <- c("19851101", "19901101", "19951101", "20001101", "20051101")
sampleData <- LoadSampleData(sdates = startDates, output = "areave")

}
