% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxrandom.R
\name{rxnormV}
\alias{rxnormV}
\alias{rxnorm}
\title{Simulate random normal variable from threefry generator}
\usage{
rxnormV(mean = 0, sd = 1, n = 1L, ncores = 1L)

rxnorm(mean = 0, sd = 1, n = 1L, ncores = 1L)
}
\arguments{
\item{mean}{vector of means.}

\item{sd}{vector of standard deviations.}

\item{n}{number of observations}

\item{ncores}{Number of cores for the simulation

\code{rxnorm} simulates using the threefry sitmo generator.

\code{rxnormV} used to simulate with the vandercorput simulator, but
since it didn't satisfy the normal properties it was changed to simple be
an alias of \code{rxnorm}. It is no longer supported in \code{rxode2({})} blocks}
}
\value{
normal random number deviates
}
\description{
Simulate random normal variable from threefry generator
}
\examples{
\donttest{
## Use threefry engine

rxnorm(n = 10) # with rxnorm you have to explicitly state n
rxnorm(n = 10, ncores = 2) # You can parallelize the simulation using openMP

rxnorm(2, 3) ## The first 2 arguments are the mean and standard deviation


## This example uses `rxnorm` directly in the model

rx <- function() {
  model({
    a <- rxnorm()
  })
}

et <- et(1, id = 1:2)

s <- rxSolve(rx, et)

}
}
