% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxsolve.R
\name{rxControlUpdateSens}
\alias{rxControlUpdateSens}
\title{This updates the tolerances based on the sensitivity equations}
\usage{
rxControlUpdateSens(rxControl, sensCmt = NULL, ncmt = NULL)
}
\arguments{
\item{rxControl}{Input list or rxControl type of list}

\item{sensCmt}{Number of sensitivity compartments}

\item{ncmt}{Number of compartments}
}
\value{
Updated rxControl where \verb{$atol}, \verb{$rtol}, \verb{$ssAtol}
\verb{$ssRtol} are updated with different sensitivities for the normal
ODEs (first) and a different sensitivity for the larger
compartments (sensitivities).
}
\description{
This assumes the normal ODE equations are the first equations and
the ODE is expanded by the forward sensitivities or other type of
sensitivity (like adjoint)
}
\examples{

tmp <- rxControl()

tmp2 <- rxControlUpdateSens(tmp, 3, 6)

tmp2$atol
tmp2$rtol
tmp2$ssAtol
tmp2$ssRtol
}
\author{
Matthew L. Fidler
}
