% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lovb.R
\name{load_lovb_player_boxscore}
\alias{load_lovb_player_boxscore}
\title{Load cleaned lovb player boxscore data from the volleydata repository.}
\usage{
load_lovb_player_boxscore(seasons = NULL)
}
\arguments{
\item{seasons}{An integer or vector of integers of seasons to fetch data for. Defaults to all available seasons.}
}
\value{
A data frame containing the player boxscore data for the specified seasons.\tabular{ll}{
   Column Name \tab Type \cr
   match_id \tab dbl \cr
   season \tab dbl \cr
   match_datetime \tab chr \cr
   player_id \tab dbl \cr
   player_name \tab chr \cr
   first_name \tab chr \cr
   last_name \tab chr \cr
   jersey_number \tab dbl \cr
   primary_position \tab dbl \cr
   roster_status \tab chr \cr
   is_foreign \tab lgl \cr
   is_confederation \tab lgl \cr
   is_captain \tab lgl \cr
   is_libero \tab lgl \cr
   set_1_is_starter \tab lgl \cr
   set_1_starting_position \tab dbl \cr
   set_2_is_starter \tab lgl \cr
   set_2_starting_position \tab dbl \cr
   set_3_is_starter \tab lgl \cr
   set_3_starting_position \tab dbl \cr
   set_4_is_starter \tab lgl \cr
   set_4_starting_position \tab dbl \cr
   set_5_is_starter \tab lgl \cr
   set_5_starting_position \tab dbl \cr
   team_name \tab chr \cr
   team_short_name \tab chr \cr
   team_code \tab chr \cr
   team_color \tab chr \cr
}
}
\description{
Load cleaned lovb player boxscore data from the volleydata repository.
}
\examples{
try({load_lovb_player_boxscore(2025)})
}
