% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.R
\name{var}
\alias{var}
\title{Correlation, Variance and Covariance (Matrices), Including Rvecs}
\usage{
var(x, y = NULL, na.rm = FALSE, use)
}
\arguments{
\item{x}{A numeric vector, matrix, data frame, or \code{\link[=rvec]{rvec()}}.}

\item{y}{NULL (default) or a vector, matrix, data frame, or rvec
with compatible dimensions to x.}

\item{na.rm}{Whether \code{NA}s removed before calculations.}

\item{use}{Calculation method. See \code{\link[stats:cor]{stats::var()}}.}
}
\value{
An rvec, if \code{x} or \code{y} is an rvec. Otherwise
typically a numeric vector or matrix.
}
\description{
Calculate correlations and variances, including when
\code{x} or \code{y} is an rvec.
}
\details{
To enable different behavior for rvecs and for ordinary vectors,
the base R function \code{\link[stats:cor]{stats::var()}} is turned into a generic,
with \code{\link[stats:cor]{stats::var()}} as the default.

For details on the calculations, see the documentation
for \code{\link[stats:cor]{stats::var()}}.
}
\examples{
x <- rvec(cbind(rnorm(10), rnorm(10, sd = 20)))
x
var(x)
}
\seealso{
\code{\link[=sd]{sd()}}
}
