% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{rvec}
\alias{rvec}
\alias{rvec_chr}
\alias{rvec_dbl}
\alias{rvec_int}
\alias{rvec_lgl}
\title{Create an Rvec from Data}
\usage{
rvec(x)

rvec_chr(x = NULL)

rvec_dbl(x = NULL)

rvec_int(x = NULL)

rvec_lgl(x = NULL)
}
\arguments{
\item{x}{A matrix, a list of vectors,
an atomic vector, or an rvec.}
}
\value{
An rvec with the following class:
\itemize{
\item \code{rvec_dbl()}: \code{"rvec_dbl"}
\item \code{rvec_int()}: \code{"rvec_int"}
\item \code{rvec_lgl()}: \code{"rvec_lgl"}
\item \code{rvec_chr()}: \code{"rvec_chr"}
\item \code{rvec()}: \code{"rvec_chr"}, \code{"rvec_dbl"}
\code{"rvec_int"}, or \code{"rvec_lgl"}
}
}
\description{
Create an object of class \code{"rvec"}, based
on input data.
}
\details{
Class \code{"rvec"} has four subclasses, each dealing with
a diffent type:
\itemize{
\item \code{"rvec_dbl"} doubles
\item \code{"rvec_int"} integers
\item \code{"rvec_lgl"} logical
\item \code{"rvec_chr"} character
}

These subclasses are analogous to \code{\link[=double]{double()}},
\code{\link[=integer]{integer()}}, \code{\link[=logical]{logical()}}, and \code{\link[=character]{character()}}
vectors.

Function \code{rvec()} chooses the subclass, based on
\code{x}. Functions \code{rvec_dbl()}, \code{rvec_int()},
\code{rvec_lgl()}, and \code{rvec_chr()} each create
objects of a particular subclass.

\code{x} can be
\itemize{
\item a matrix, where each row is a set of draws
for an unknown quantity;
\item a list, where each element is a set of draws;
\item an atomic vector, which is treated as a
single-column matrix; or
\item an rvec.
}
}
\examples{
m <- rbind(c(-1.5, 2, 0.2),
           c(-2.3, 3, 1.2))
rvec_dbl(m)

l <- list(rpois(100, lambda = 10.2),
          rpois(100, lambda = 5.5))
rvec(l)

rvec(letters[1:5])

l <- list(a = c(TRUE, FALSE),
          b = c(FALSE, TRUE))
rvec(l)
}
\seealso{
\itemize{
\item \code{\link[=new_rvec]{new_rvec()}} Create a blank rvec.
\item \code{\link[=collapse_to_rvec]{collapse_to_rvec()}} Create rvecs within
a data frame.
\item \code{\link[=rnorm_rvec]{rnorm_rvec()}}, \code{\link[=rbinom_rvec]{rbinom_rvec()}}, etc. Create rvecs
representing probability distributions.
}
}
