% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_rvec.R
\name{map_rvec}
\alias{map_rvec}
\title{Apply a Function and Put Results in an Rvec}
\usage{
map_rvec(.x, .f, ...)
}
\arguments{
\item{.x}{A vector.}

\item{.f}{A function.}

\item{...}{Additional arguments passed to \code{.f}.}
}
\value{
An \link[=rvec]{rvec} with the same
length as \code{.x}.
}
\description{
Apply function \code{.f} to each element of \code{.x},
and then combine the results into an
rvec with the same length as \code{.x}.
}
\details{
Each call to function \code{.f} should produce
an \link[=rvec]{rvec} with length 1.
}
\examples{
l <- list(a = rvec(matrix(1:2, 1)),
          b = rvec(matrix(1:4, 2)),
          c = rvec(matrix(1:6, 3)))
l
map_rvec(l, sum)

## sapply does not work with rvecs
sapply(l, sum)
}
\seealso{
\code{map_rvec()} is based on the
map functions in package
\href{https://purrr.tidyverse.org/reference/map.html}{purrr},
though the internal implementation is different.

Base R functions \code{\link[=sapply]{sapply()}} and \code{\link[=vapply]{vapply()}}
do not work properly with rvecs.
[lapply() works, but to combine the
results into a single rvec, functions such
as \code{\link[=c]{c()}} or \code{\link[vctrs:vec_c]{vctrs::vec_c()}} are needed.
}
