% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws.R
\name{draws_quantile}
\alias{draws_quantile}
\alias{draws_quantile.rvec}
\alias{draws_quantile.rvec_chr}
\title{Quantiles Across Random Draws}
\usage{
draws_quantile(x, probs = c(0.025, 0.25, 0.5, 0.75, 0.975), na_rm = FALSE)

\method{draws_quantile}{rvec}(x, probs = c(0.025, 0.25, 0.5, 0.75, 0.975), na_rm = FALSE)

\method{draws_quantile}{rvec_chr}(x, probs = c(0.025, 0.25, 0.5, 0.75, 0.975), na_rm = FALSE)
}
\arguments{
\item{x}{An object of class \link[=rvec]{rvec}.}

\item{probs}{Vector of probabilities.}

\item{na_rm}{Whether to remove NAs before
calculating summaries. Default is \code{FALSE}.}
}
\value{
A \link[tibble:tibble]{tibble}.
}
\description{
Summarise the distribution of random draws
in an \code{rvec}, using quantiles.
}
\details{
The \code{probs} argument defaults to
\code{c(0.025, 0.25, 0.5, 0.75, 0.975)},
the values needed for a median,
a 50\% credible intervals, and a
95\% credible interval.
}
\section{Warning}{


It is tempting to assign the results
of a call to \code{draws_quantile()} to a
column in a data frame,
as in

\code{my_df$quantile <- draws_quantile(my_rvec)}

However, creating data frame columns in
this way can corrupt data
frames. For safer options,
see the examples below.
}

\examples{
set.seed(0)
m <- rbind(a = rnorm(100, mean = 5, sd = 2),
           b = rnorm(100, mean = -3, sd = 3),
           c = rnorm(100, mean = 0, sd = 20))
x <- rvec(m)
x
draws_quantile(x)

## results from 'draws_quantile'
## assigned to a data frame
library(dplyr)
df <- data.frame(x)

## base R approach
cbind(df, draws_quantile(x))

## a tidyverse alternative:
## mutate with no '='
df |>
  mutate(draws_quantile(x))
}
\seealso{
\code{\link[=draws_ci]{draws_ci()}} creates simple credible intervals.

Other functions for applying pre-specified
functions across draws are:
\itemize{
\item \code{\link[=draws_all]{draws_all()}}
\item \code{\link[=draws_any]{draws_any()}}
\item \code{\link[=draws_ci]{draws_ci()}}
\item \code{\link[=draws_min]{draws_min()}}
\item \code{\link[=draws_max]{draws_max()}}
\item \code{\link[=draws_median]{draws_median()}}
\item \code{\link[=draws_mean]{draws_mean()}}
\item \code{\link[=draws_mode]{draws_mode()}}
}

Apply arbitrary function across draws:
\itemize{
\item \code{\link[=draws_fun]{draws_fun()}}
}

For additional functions for summarising random draws, see
\href{https://CRAN.R-project.org/package=tidybayes}{tidybayes}
and \href{https://CRAN.R-project.org/package=ggdist}{ggdist}.
Function \code{\link[=as_list_col]{as_list_col()}} converts rvecs into a
format that \code{tidybayes} and \code{ggdist} can work with.
}
