% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dbinom_rvec}
\alias{dbinom_rvec}
\alias{pbinom_rvec}
\alias{qbinom_rvec}
\alias{rbinom_rvec}
\title{The Binomial Distribution, Using Multiple Draws}
\usage{
dbinom_rvec(x, size, prob, log = FALSE)

pbinom_rvec(q, size, prob, lower.tail = TRUE, log.p = FALSE)

qbinom_rvec(p, size, prob, lower.tail = TRUE, log.p = FALSE)

rbinom_rvec(n, size, prob, n_draw = NULL)
}
\arguments{
\item{x}{Quantiles. Can be an rvec.}

\item{size}{Number of trials.
See \code{\link[stats:Binomial]{stats::dbinom()}}. Can be an rvec.}

\item{prob}{Probability of success in each trial.
See \code{\link[stats:Binomial]{stats::dbinom()}}. Can be an rvec.}

\item{log, log.p}{Whether to return results
on a log scale. Default is
\code{FALSE}. Cannot be an rvec.}

\item{q}{Quantiles. Can be an rvec.}

\item{lower.tail}{Whether to return
\eqn{P[X \le x]}, as opposed to
\eqn{P[X > x]}. Default is \code{TRUE}.
Cannot be an rvec.}

\item{p}{Probabilities. Can be an rvec.}

\item{n}{The length of random vector being
created. Cannot be an rvec.}

\item{n_draw}{Number of random draws
in the random vector being
created. Cannot be an rvec.}
}
\value{
\itemize{
\item If any of the arguments are rvecs,
or if a value for \code{n_draw} is supplied,
then an \link[=rvec]{rvec}
\item Otherwise an ordinary R vector.
\item \code{rbinom_rvec()} always returns doubles (not integers).
}
}
\description{
Density, distribution function,
quantile function and random generation for the
binomial distribution, modified to work with
rvecs.
}
\details{
Functions \code{dbinom_rvec()}, \code{pbinom_rvec()},
\code{pbinom_rvec()} and \code{rbinom_rvec()} work like
base R functions \code{\link[=dbinom]{dbinom()}}, \code{\link[=pbinom]{pbinom()}},
\code{\link[=qbinom]{qbinom()}}, and \code{\link[=rbinom]{rbinom()}}, except that
they accept rvecs as inputs. If any
input is an rvec, then the output will be too.
Function \code{rbinom_rvec()} also returns an
rvec if a value for \code{n_draw} is supplied.

\code{dbinom_rvec()}, \code{pbinom_rvec()},
\code{pbinom_rvec()} and \code{rbinom_rvec()}
use \link[vctrs:theory-faq-recycling]{tidyverse}
vector recycling rules:
\itemize{
\item Vectors of length 1 are recycled
\item All other vectors must have the same size
}
}
\section{Warning}{


From version rvec version 0.7.4 onwards,
\code{rbinom_rvec()} always returns doubles (not integers).
}

\examples{
x <- rvec(list(c(3, 8),
               c(0, 2)))
dbinom_rvec(x, size = 8, prob = 0.3)
pbinom_rvec(x, size = 8, prob = 0.3)

rbinom_rvec(n = 2,
            size = 10,
            prob = c(0.7, 0.3),
            n_draw = 1000)
}
\seealso{
\itemize{
\item \code{\link[=dbinom]{dbinom()}}
\item \code{\link[=pbinom]{pbinom()}}
\item \code{\link[=qbinom]{qbinom()}}
\item \code{\link[=rbinom]{rbinom()}}
\item \link[stats:Distributions]{stats::distributions}.
}
}
