% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tik_get_report.R
\name{tik_get_report}
\alias{tik_get_report}
\title{Get Marketing Report}
\usage{
tik_get_report(
  advertiser_id = NULL,
  advertiser_ids = NULL,
  bc_id = NULL,
  service_type = NULL,
  report_type = "BASIC",
  data_level = "AUCTION_ADVERTISER",
  dimensions = c("advertiser_id", "stat_time_day"),
  metrics = "spend",
  enable_total_metrics = FALSE,
  start_date = Sys.Date() - 7,
  end_date = Sys.Date() - 1,
  query_lifetime = FALSE,
  multi_adv_report_in_utc_time = FALSE,
  order_field = NULL,
  order_type = NULL
)
}
\arguments{
\item{advertiser_id}{Advertiser ID. You need to pass in either advertiser_id/advertiser_ids or bc_id.
\itemize{
\item When report_type is set to BASIC or AUDIENCE, pass in advertiser_id or advertiser_ids. If you pass in both advertiser_id and advertiser_ids, advertiser_id will be ignored.
\item When report_type is set to PLAYABLE_MATERIAL, CATALOG, or TT_SHOP, pass in advertiser_id.
\item When report_type is set to BC, pass in bc_id.
}}

\item{advertiser_ids}{A list of advertiser IDs.}

\item{bc_id}{ID of a Business Center that you have access to.}

\item{service_type}{Ad service type. Not supported when report_type is BC.
\itemize{
\item AUCTION: auction ads, or both auction ads and reservation ads.
\item RESERVATION (deprecated) : reservation ads.
}}

\item{report_type}{Report type:
\itemize{
\item BASIC: basic report.
\item AUDIENCE: audience report.
\item PLAYABLE_MATERIAL: playable ads report.
\item CATALOG: DSA report.
\item BC: Business Center report.
\item TT_SHOP: GMV max ads report.
}}

\item{data_level}{The data level that you'd like to query in reports.
\itemize{
\item AUCTION_AD: auction ads or both auction ads and reservation ads, ad level.
\item AUCTION_ADGROUP: auction ads or both auction ads and reservation ads, ad group level.
\item AUCTION_CAMPAIGN: auction ads or both auction ads and reservation ads, campaign level.
\item AUCTION_ADVERTISER: auction ads or both auction ads and reservation ads, advertiser level.
}}

\item{dimensions}{Grouping conditions. For example: ("campaign_id", "stat_time_day") indicates that both campaign_id and stat_time_day (days) are grouped. Different report types support different dimensions.
\itemize{
\item Supported dimensions in \href{https://business-api.tiktok.com/portal/docs?id=1751443956638721}{basic reports}
\item Supported dimensions in \href{https://business-api.tiktok.com/portal/docs?id=1751454103714818}{audience reports}
\item Supported dimensions in \href{https://business-api.tiktok.com/portal/docs?id=1751617879104514}{playable ad reports}
\item Supported dimensions in \href{https://business-api.tiktok.com/portal/docs?id=1751617879104514}{DSA reports}
\item Supported dimensions in \href{https://business-api.tiktok.com/portal/docs?id=1775747465089026}{Business Center reports}
\item Supported dimensions in \href{https://business-api.tiktok.com/portal/docs?id=1803073629472770}{GMV max ads reports}
}}

\item{metrics}{Metrics to query. Different report types support different metrics. For supported metrics for each report type, see the corresponding articles under \href{https://business-api.tiktok.com/portal/docs?id=1738864835805186}{Report types}.}

\item{enable_total_metrics}{Whether to enable the total added-up data for your requested metrics. When enable_total_metrics is enabled, we will provide the aggregate data for all pages as you query different pages. Under this condition, you only need to specify this field when requesting data for the first page.}

\item{start_date}{Query start date (closed interval) in the format of YYYY-MM-DD. The date is based on the ad account time zone.}

\item{end_date}{Query end date (closed interval) in the format of YYYY-MM-DD. The date is based on the ad account time zone.}

\item{query_lifetime}{Whether to request the lifetime metrics. Default value: False. If query_lifetime = True, the start_date and end_date parameters will be ignored. The lifetime metric name is the same as the normal one.}

\item{multi_adv_report_in_utc_time}{Whether to set the returned metrics in the local timezone of each respective advertiser.}

\item{order_field}{Sorting field.}

\item{order_type}{Sorting order. ASC or DESC.}
}
\value{
tibble with report data
}
\description{
Use this function to create a synchronous report task.
This function can currently return the reporting data of up to 20,000 advertisements. If your number of advertisements exceeds 20,000, please use campaign_ids / adgroup_ids / ad_ids as a filter to obtain the reporting data of all advertisements in batches. If you use campaign_ids / adgroup_ids / ad_ids as a filter, you can pass in up to 100 IDs at a time.
}
\details{
To take more details see \href{https://business-api.tiktok.com/portal/docs?id=1740302848100353&rid=uz955smt6w}{API documentation}
}
\examples{
\dontrun{
report <- tik_get_report(advertiser_id = '7499750467069771792')
}
}
