% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Robust_Stepwise_Split.R
\name{robustStepwiseSplit}
\alias{robustStepwiseSplit}
\title{Robust Multi-Model Stepwise Variable Selection}
\usage{
robustStepwiseSplit(
  Rx,
  Ry,
  n_models = 1,
  model_saturation = "p-value",
  alpha = 0.05,
  model_size = NULL,
  n = nrow(Rx)
)
}
\arguments{
\item{Rx}{Robust correlation matrix of predictors (p x p matrix).}

\item{Ry}{Robust correlation vector between response and predictors (p x 1 vector).}

\item{n_models}{Number of models to build. Default is 1.}

\item{model_saturation}{Criterion to determine model saturation. Either "p-value" 
or "fixed". Default is "p-value".}

\item{alpha}{P-value threshold for determining model saturation when 
model_saturation = "p-value". Default is 0.05.}

\item{model_size}{Maximum number of variables per model when model_saturation = 
"fixed". Default is NULL.}

\item{n}{Sample size used for computing test statistics. Default is nrow(Rx).}
}
\value{
If n_models = 1, returns a vector of 0-indexed selected variable indices.
  If n_models > 1, returns a list where each element contains the 0-indexed 
  selected variable indices for the corresponding model.
}
\description{
Internal function that performs robust stepwise variable selection 
for building disjoint ensemble models. Uses robust correlation estimates to 
select predictor subsets while ensuring variables are not shared across models.
}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
\keyword{internal}
