% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npn_phenophases.R
\name{npn_get_phenophases_for_taxon}
\alias{npn_get_phenophases_for_taxon}
\title{Get Phenophases for Taxon}
\usage{
npn_get_phenophases_for_taxon(
  family_ids = NULL,
  order_ids = NULL,
  class_ids = NULL,
  genus_ids = NULL,
  date = NULL,
  return_all = deprecated(),
  ...
)
}
\arguments{
\item{family_ids}{Integer vector of taxonomic family ids to search for.}

\item{order_ids}{Integer vector of taxonomic order ids to search for.}

\item{class_ids}{Integer vector of taxonomic class ids to search for}

\item{genus_ids}{Integer vector of taxonomic genus ids to search for}

\item{date}{Specify the date of interest as a \code{Date} or \code{character} of the
format \code{"YYYY-MM-DD"}. To return data from all dates, use \code{date = "all"}.}

\item{return_all}{Deprecated.  Use \code{date = "all"} to return data from all
dates.}

\item{...}{Currently unused.}
}
\value{
A data frame listing phenophases in the NPN database for the
specified taxon and date.
}
\description{
This function gets a list of phenophases that are applicable for a provided
taxonomic grouping, e.g. family, order. Note that since a higher taxononmic
order will aggregate individual species not every phenophase returned through
this function will be applicable for every species belonging to that
taxonomic group.
}
\details{
It's also important to note that phenophase definitions can change for
individual species over time, so there's a need to specify either a date of
interest, or to explicitly state that the function should return all
phenophases that were ever applicable for any species belonging to the
specified taxonomic group.

When called, this function requires of these three parameters, exactly one of
\code{family_ids}, \code{order_ids} or \code{class_ids} to be set.
}
\examples{
\dontrun{
npn_get_phenophases_for_taxon(class_ids = c(5, 6), date = "2018-05-05")
npn_get_phenophases_for_taxon(family_ids = c(267, 268), date = "2018-05-05")

#if you supply two or more "ids" arguments, the highest classification takes precedence
pheno <- npn_get_phenophases_for_taxon(
  class_ids = 4,
  family_ids = c(103, 104),
  genus_ids = c(409, 957, 610),
  date = "2018-05-05"
)

colnames(pheno)
# [1] "family_id"   "family_name" "phenophases"
}
}
