% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ne_file_name.R
\name{ne_file_name}
\alias{ne_file_name}
\title{return a natural earth filename based on arguments}
\usage{
ne_file_name(
  scale = 110L,
  type = "countries",
  category = c("cultural", "physical", "raster")
)
}
\arguments{
\item{scale}{The scale of map to return, one of `110`, `50`, `10` or `small`,
`medium`, `large`.}

\item{type}{type of natural earth file to download one of 'countries',
'map_units', 'map_subunits', 'sovereignty', 'states' OR the portion of any
natural earth vector url after the scale and before the . e.g. for
'ne_50m_urban_areas.zip' this would be 'urban_areas' OR the raster
filename e.g. for 'MSR_50M.zip' this would be 'MSR_50M'}

\item{category}{one of natural earth categories : 'cultural', 'physical',
'raster'}
}
\value{
string
}
\description{
returns a string that can then be used to download the file.
}
\details{
Note that the filename of the requested object will be returned if
`load = FALSE`.

If the data is to be loaded into memory (`load = TRUE`), the download will
be handled using the GDAL virtual file system, allowing direct access to the
data without writing it to disk.
}
\examples{
ne_url <- ne_file_name(scale = 110, type = "countries")

}
\seealso{
\code{\link{ne_load}}, pre-downloaded data are available using
  \code{\link{ne_countries}}, \code{\link{ne_states}}. Other geographic data
  are available in the raster package : \code{\link[raster]{getData}}.
}
