% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{isUndefined}
\alias{isUndefined}
\title{Tell if a variable's value is undefined (NA or NULL); If yes, and it is required by the mzQC standard,
we can raise an error.}
\usage{
isUndefined(s, ..., verbose = TRUE, context = NULL)
}
\arguments{
\item{s}{A variable to be checked for NA/NULL}

\item{...}{More variable to be checked}

\item{verbose}{If TRUE and 's' is NULL/NA, will print the name of the variable which was passed in}

\item{context}{An optional string will be using within a warning message, to ease tracking of where in the mzQC structure the undefined value occurs}
}
\description{
You can pass multiple variable, which are all checked.
If \strong{any} of them is undefined, the function returns TRUE
}
\examples{
isUndefined(NA)       ## TRUE
isUndefined(NULL)     ## TRUE
isUndefined(NA, NULL) ## TRUE
isUndefined("")       ## FALSE
isUndefined(list(1,2,3)) ## FALSE
isUndefined("", NA)   ## TRUE
isUndefined(NA, "")   ## TRUE
isUndefined(1)        ## FALSE
myVar = NA
isUndefined(myVar)    ## TRUE, with warning "Variable 'myVar' is NA/NULL!"

}
